/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected;

import org.sonarsource.sonarlint.core.client.api.connected.ConnectedGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.GlobalUpdateStatus;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ValidationResult;
import org.sonarsource.sonarlint.core.container.ComponentContainer;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.update.GlobalPropertiesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.GlobalUpdateExecutor;
import org.sonarsource.sonarlint.core.container.connected.update.ModuleConfigUpdateExecutor;
import org.sonarsource.sonarlint.core.container.connected.update.ModuleListDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.PluginReferencesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.RulesDownloader;
import org.sonarsource.sonarlint.core.container.connected.validate.AuthenticationChecker;
import org.sonarsource.sonarlint.core.container.connected.validate.ServerVersionAndStatusChecker;
import org.sonarsource.sonarlint.core.container.global.GlobalTempFolderProvider;
import org.sonarsource.sonarlint.core.container.storage.StorageManager;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCacheProvider;
import org.sonarsource.sonarlint.core.plugin.cache.PluginHashes;

public class ConnectedContainer
extends ComponentContainer {
    private final ServerConfiguration serverConfiguration;
    private final ConnectedGlobalConfiguration globalConfig;

    public ConnectedContainer(ConnectedGlobalConfiguration globalConfig, ServerConfiguration serverConfiguration) {
        this.globalConfig = globalConfig;
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    protected void doBeforeStart() {
        this.add(this.globalConfig, this.serverConfiguration, new GlobalTempFolderProvider(), ServerVersionAndStatusChecker.class, AuthenticationChecker.class, SonarLintWsClient.class, GlobalUpdateExecutor.class, ModuleConfigUpdateExecutor.class, PluginReferencesDownloader.class, GlobalPropertiesDownloader.class, ModuleListDownloader.class, RulesDownloader.class, new PluginCacheProvider(), PluginHashes.class, StorageManager.class);
    }

    public ValidationResult validateConnection() {
        ValidationResult result = this.getComponentByType(ServerVersionAndStatusChecker.class).validateStatusAndVersion();
        if (result.success()) {
            return this.getComponentByType(AuthenticationChecker.class).validateCredentials();
        }
        return result;
    }

    public void update() {
        this.getComponentByType(GlobalUpdateExecutor.class).update();
    }

    public void updateModule(String moduleKey) {
        GlobalUpdateStatus updateStatus = this.getComponentByType(StorageManager.class).getGlobalUpdateStatus();
        if (updateStatus == null) {
            throw new IllegalStateException("Please update server first");
        }
        this.getComponentByType(ModuleConfigUpdateExecutor.class).update(moduleKey);
    }
}

